/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge;

import com.fizzware.dramaticdoors.forge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallSlidingDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallStableDoorBlock;
import com.fizzware.dramaticdoors.forge.items.ModdedTab;
import com.fizzware.dramaticdoors.forge.items.ShortDoorItem;
import com.fizzware.dramaticdoors.forge.items.TallDoorItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class DDRegistry {
    public static final List<Pair<String, Block>> DOOR_BLOCKS_TO_REGISTER = new ArrayList<Pair<String, Block>>();
    public static final List<Pair<String, Item>> DOOR_ITEMS_TO_REGISTER = new ArrayList<Pair<String, Item>>();
    public static final Item.Properties PROPERTIES = new Item.Properties();
    public static CreativeModeTab MAIN_TAB = null;
    public static CreativeModeTab CHIPPED_TAB = null;
    public static CreativeModeTab MACAW_TAB = null;
    public static CreativeModeTab MANYIDEAS_TAB = null;

    public static void registerTabs(ModdedTab tabSystem) {
        MAIN_TAB = tabSystem.createTab("dramaticdoors", () -> new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation("dramaticdoors", "tall_oak_door"))), null);
        CHIPPED_TAB = tabSystem.createTab("dramaticdoors_chipped", () -> new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation("dramaticdoors", "tall_chipped_gated_birch_door"))), "chipped");
        MACAW_TAB = tabSystem.createTab("dramaticdoors_macaw", () -> new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation("dramaticdoors", "tall_macaw_dark_oak_barn_door"))), "mcwdoors");
        MANYIDEAS_TAB = tabSystem.createTab("dramaticdoors_manyideas", () -> new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation("dramaticdoors", "tall_manyideas_crimson_blank_door"))), "manyideas_doors");
    }

    public static void registerVanilla() {
        DDRegistry.registerDoorBlockAndItem("tall_iron_door", "short_iron_door", Blocks.f_50166_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_oak_door", "short_oak_door", Blocks.f_50154_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_spruce_door", "short_spruce_door", Blocks.f_50484_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_birch_door", "short_birch_door", Blocks.f_50485_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_jungle_door", "short_jungle_door", Blocks.f_50486_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_acacia_door", "short_acacia_door", Blocks.f_50487_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_dark_oak_door", "short_dark_oak_door", Blocks.f_50488_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_mangrove_door", "short_mangrove_door", Blocks.f_220853_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_crimson_door", "short_crimson_door", Blocks.f_50671_, true, MAIN_TAB);
        DDRegistry.registerDoorBlockAndItem("tall_warped_door", "short_warped_door", Blocks.f_50672_, true, MAIN_TAB);
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, boolean includeShort, CreativeModeTab tab) {
        Block tempBlock = DDRegistry.createDoorBlock(block, true);
        Item tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(block, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerDoorBlockAndItem(String tallname, @Nullable String shortname, BlockBehaviour.Properties properties, boolean includeShort, CreativeModeTab tab) {
        Block tempBlock = DDRegistry.createDoorBlock(properties, true);
        Item tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createDoorBlock(properties, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerSlidingDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, boolean includeShort, CreativeModeTab tab) {
        Block tempBlock = DDRegistry.createSlidingDoorBlock(block, true);
        Item tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createSlidingDoorBlock(block, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    public static void registerStableDoorBlockAndItem(String tallname, @Nullable String shortname, Block block, boolean includeShort, CreativeModeTab tab) {
        Block tempBlock = DDRegistry.createStableDoorBlock(block, true);
        Item tempItem = DDRegistry.createDoorItem(tempBlock, true, tab);
        DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)tallname, (Object)tempBlock));
        DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)tallname, (Object)tempItem));
        if (includeShort) {
            tempBlock = DDRegistry.createStableDoorBlock(block, false);
            tempItem = DDRegistry.createDoorItem(tempBlock, false, tab);
            DOOR_BLOCKS_TO_REGISTER.add((Pair<String, Block>)new Pair((Object)shortname, (Object)tempBlock));
            DOOR_ITEMS_TO_REGISTER.add((Pair<String, Item>)new Pair((Object)shortname, (Object)tempItem));
        }
    }

    protected static Block createSlidingDoorBlock(Block block, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw sliding doors are currently not supported.");
        }
        TallSlidingDoorBlock tempBlock = new TallSlidingDoorBlock(block);
        return tempBlock;
    }

    protected static Block createStableDoorBlock(Block block, boolean isTall) {
        if (!isTall) {
            throw new IllegalArgumentException("Short version of Macaw stable doors are currently not supported.");
        }
        TallStableDoorBlock tempBlock = new TallStableDoorBlock(block);
        return tempBlock;
    }

    protected static Block createDoorBlock(Block block, boolean isTall) {
        Block tempBlock = isTall ? new TallDoorBlock(block) : new ShortDoorBlock(block);
        return tempBlock;
    }

    protected static Block createDoorBlock(BlockBehaviour.Properties properties, boolean isTall) {
        Block tempBlock = isTall ? new TallDoorBlock(properties) : new ShortDoorBlock(properties);
        return tempBlock;
    }

    protected static Item createDoorItem(Block block, boolean isTall, CreativeModeTab tab) {
        BlockItem tempItem = isTall ? new TallDoorItem(block, PROPERTIES.m_41491_(tab)) : new ShortDoorItem(block, PROPERTIES.m_41491_(tab));
        return tempItem;
    }

    public static Block getBlockByKey(ResourceLocation loc) {
        return DDRegistry.getBlockByKey(loc, Blocks.f_50154_);
    }

    public static Block getBlockByKey(ResourceLocation loc, Block fallback) {
        if (Registry.f_122824_.m_7804_(loc)) {
            return (Block)Registry.f_122824_.m_7745_(loc);
        }
        return fallback;
    }

    public static Block getBlockFromResourceLocation(ResourceLocation resource) {
        return DDRegistry.getBlockFromResourceLocation(resource, Blocks.f_50154_);
    }

    public static Block getBlockFromResourceLocation(ResourceLocation resource, Block fallback) {
        return Registry.f_122824_.m_6612_(resource).orElse(fallback);
    }
}

